﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Potwierdzenie salda</title>
	<script runat="server">

		public class Params : ContextBase
		{
			private bool wgKont;
			private bool kontoWirtualne;
			private Arkusze wariant;


			public enum Arkusze
			{
				[Caption("A+B")]
				AB, 
				[Caption("A+B+B")]
				ABB, 
				[Caption("B")]
				B
			}

			
			public Params(Context ctx)
				: base(ctx)
			{
				wgKont = true;
				kontoWirtualne = false;
				wariant = Arkusze.AB;
			}


			[Priority(10)]
			[DefaultWidth(10)]
			[Caption("Wariant wydruku")]
			public Arkusze Wariant
			{
				get { return wariant; }
				set { wariant = value; }
			}

			
			[Priority(20)]
			[Caption("Grupuj wg kont")]
			public bool WgKont
			{
				get { return wgKont; }
				set { wgKont = value; }
			}

			[Priority(30)]
			[Caption("Rachunek wirtualny")]
			public bool KontoWirtualne
			{
				get { return kontoWirtualne; }
				set { kontoWirtualne = value; }
			}

            [Priority(99)]
            [Caption("Adres korespondencyjny")]
            public Boolean AdresKorespondencyjny { get; set; }
		}


		private Params prm;

		[Context]
		public Params Prm
		{ set { prm = value; } }


		private class Total
		{
			readonly string opis;
			readonly decimal nal;
			readonly decimal zob;
			
			public Total(string opis, decimal nal, decimal zob)
			{
				this.opis = opis;
				this.nal = nal;
				this.zob = zob;
			}

			public string Opis
			{ get { return opis; } }

			public decimal Należność
			{ get { return nal; } }

			public decimal Zobowiązanie
			{ get { return zob; } }
		}

		
		private class WgWaluty
		{
			private class ComparePSP : IComparer
			{
				public int Compare(object x, object y)
				{
					PotwierdzenieSaldaPozycja px = (PotwierdzenieSaldaPozycja)x;
					PotwierdzenieSaldaPozycja py = (PotwierdzenieSaldaPozycja)y;

					if (px == null && py == null)
						return 0;
					if (px == null)
						return -1;
					if (py == null)
						return 1;

					int i = px.DataDokumentu.CompareTo(py.DataDokumentu);
					if (i == 0)
						i = px.NumerDokumentu.CompareTo(py.NumerDokumentu);
					return i;
				}
			}

			private readonly string symbol;
			private readonly string konto;
			private readonly ArrayList lista = new ArrayList();
			private decimal zob;
			private decimal nal;
			
			public WgWaluty(string symbol, string konto)
			{
				this.symbol = symbol;
				this.konto = konto;
			}
			
			public void Add(PotwierdzenieSaldaPozycja pozycja)
			{
				lista.Add(pozycja);
				zob += pozycja.Zobowiązanie.Value;
				nal += pozycja.Należność.Value;
			}

			public string Symbol
			{ get { return symbol; } }
			public string Konto
			{ get { return konto; } }
			
			public ArrayList Pozycje
			{
				get
				{
					lista.Sort(new ComparePSP());
					return lista;
				}
			}
			
			public IEnumerable Podsumowanie
			{
				get
				{
					return new object[] 
					{
                    new Total("<b>Razem:</b>", nal, zob),
                    new Total("<b>Saldo:</b>", nal>zob ? nal - zob : 0m, zob>nal ? zob - nal : 0m)
					};
				}
			}
		}

		ZapisElementuKsiegowalnego worker = new ZapisElementuKsiegowalnego();

		
		void OnContextLoad(Object sender, EventArgs args)
		{
			PotwierdzenieSalda doc = (PotwierdzenieSalda)dc[typeof(PotwierdzenieSalda)];

			BlockA.Visible = prm.Wariant != Params.Arkusze.B;
			BlockB.Visible = true;
			PageBreak1.BreakFirstTimes = prm.Wariant != Params.Arkusze.B;

			BlockA.DataSource = new PotwierdzenieSalda[] { doc };
			BlockB.DataSource = prm.Wariant == Params.Arkusze.ABB ? new PotwierdzenieSalda[] { doc, doc } : new PotwierdzenieSalda[] { doc };

			BlockA.DataContext = dc;
			BlockB.DataContext = dc;

			IPieczątkaFirmy pieczatka = ReportHeader.GetPieczątka(dc);
			String nazwaStr = pieczatka.NazwaFormatowana + "|" + pieczatka.Adres.Linia1 + "|" + pieczatka.Adres.Linia2;
			IdNazwaWlasna2.EditValue = IdNazwaWlasna1.EditValue = Soneta.HTML.HtmlParser.HtmlEncode(nazwaStr).Replace("|", "<BR/>");

			Hashtable ht = new Hashtable();

			if (doc.Zerowe)
			{
				ht.Add("PLN|(wszystkie)", new WgWaluty("PLN", "(wszystkie)"));
			}
			else
				foreach (PotwierdzenieSaldaPozycja pozycja in doc.Pozycje)
				{
					string symbol = pozycja.Kwota.Symbol;
					worker.Element = (IElementKsiegowalny)pozycja.Platnosc;

					string konto = prm.WgKont ? (String.IsNullOrEmpty(worker.GetKontoWgDaty(doc.Data)) ? "(bez konta)" : worker.GetKontoWgDaty(doc.Data)) : "(wszystkie)";
					string key = symbol + "|" + konto;

					WgWaluty wgw = (WgWaluty)ht[key];
					if (wgw == null)
						ht.Add(key, wgw = new WgWaluty(symbol, konto));
					wgw.Add(pozycja);
				}

			
			
			

			if (prm.KontoWirtualne && doc.RachunekWirtualny != null)
			{
				ScWirtualny.Visible = true;
				IdBankWirt.Visible = doc.RachunekWirtualny.EwidencjaSP.Rachunek.Bank != null;
				IdSwiftWirt.Visible = !String.IsNullOrEmpty(doc.RachunekWirtualny.EwidencjaSP.Rachunek.SWIFT);
			}
			else if(doc.RachunekBankowy!=null)
			{
				ScRegularny.Visible = true;
				IdBankReg.Visible = doc.RachunekBankowy.Rachunek.Bank != null;
				IdSwiftReg.Visible = !String.IsNullOrEmpty(doc.RachunekBankowy.Rachunek.SWIFT);
			}
			

			DataRepeater1.DataSource = ht.Values;
			DataRepeater2.DataSource = ht.Values;

			if (doc.Zerowe)
			{
				SectionKontoId.Visible = false;
				SectionPrzypomnienieId.Visible = false;
				CmNaleznoscId1.HideZero = false;
				CmNaleznoscId2.HideZero = false;
				CmZobowiazanieId1.HideZero = false;
				CmZobowiazanieId2.HideZero = false;
			}

            var kh = doc.Podmiot as Kontrahent;
            if (kh != null && prm.AdresKorespondencyjny && !String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy + kh.AdresDoKorespondencji.Linia1 + kh.AdresDoKorespondencji.Linia2))
            {
                LblAdPodmiot.EditValue = String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy) ? doc.Podmiot.NazwaFormatowana : kh.KorespondencjaNazwaFirmy;
                LblAdAdresLinia1.EditValue = kh.AdresDoKorespondencji.Linia1;
                LblAdAdresLinia2.EditValue = kh.AdresDoKorespondencji.Linia2;
                ScAdresat.Visible = true;
            }
            LblPodmiot.EditValue = Lbl2Podmiot.EditValue = doc.Podmiot.NazwaFormatowana;
            LblAdresLinia1.EditValue = Lbl2AdresLinia1.EditValue = doc.Podmiot.Adres.Linia1;
            LblAdresLinia2.EditValue = Lbl2AdresLinia2.EditValue = doc.Podmiot.Adres.Linia2;
		}

	</script>
</head>
<body>
	<form id="PotwierdzenieSalda" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" TypeName="Soneta.Kasa.PotwierdzenieSalda,Soneta.Kasa" />

	<ea:DataRepeater runat="server" Id="BlockA" WithSections="false">

	<cc1:ReportHeader ID="ReportHeader1" Title="Potwierdzenie salda|</strong>Numer: <strong>{0}|</strong>Na dzień: <strong>{1}|ODCINEK A" runat="server" DataMember1="Data" DataMember0="Numer"  />
	<ea:Section runat="server" ID="SectionKontoId">
				<em>Konto bankowe:</em> <br/>
				<ea:Section runat="server" ID="ScWirtualny" Visible="false">
					<ea:DataLabel id="IdBankWirt" runat="server" Format="{0}<br/>" DataMember="RachunekWirtualny.EwidencjaSP.Rachunek.Bank.Nazwa"></ea:DataLabel>
					<ea:DataLabel id="IdSwiftWirt" runat="server" Format="SWIFT: {0}<br/>" DataMember="RachunekWirtualny.EwidencjaSP.Rachunek.SWIFT"></ea:DataLabel>
					<ea:DataLabel id="DataLabel22" runat="server" DataMember="RachunekWirtualny.Numer"></ea:DataLabel>
				</ea:Section>
				<ea:Section runat="server" ID="ScRegularny" Visible="false">
					<ea:DataLabel id="IdBankReg" runat="server" Format="{0}<br/>" DataMember="RachunekBankowy.Rachunek.Bank.Nazwa"></ea:DataLabel> 
					<ea:DataLabel id="IdSwiftReg" runat="server" Format="SWIFT: {0}<br/>" DataMember="RachunekBankowy.Rachunek.SWIFT"></ea:DataLabel>
					<ea:DataLabel id="DataLabel23" runat="server" DataMember="RachunekBankowy.Rachunek.Numer"></ea:DataLabel>
				</ea:Section>

	</ea:Section>
	<p>
		<em>Nadawca:</em><br/>
		<ea:DataLabel ID="IdNazwaWlasna1" runat="server" />
	</p>
        <table style="width: 100%; border:hidden">
            <tbody>
                <tr>
                    <td valign="top" width="50%" >
		                <p>
			                <em>Odbiorca:</em><br />
			                <ea:DataLabel ID="LblPodmiot" runat="server" /><br />
			                <ea:DataLabel ID="LblAdresLinia1" runat="server" /><br />
			                <ea:DataLabel ID="LblAdresLinia2" runat="server" />
		                </p>
                    </td>
                    <td valign="top" width="50%">
                        <ea:Section runat="server" ID="ScAdresat" Visible="false">
                        <p>
			                <em>Adres korespondencyjny:</em><br />
			                <ea:DataLabel ID="LblAdPodmiot" runat="server" /><br />
			                <ea:DataLabel ID="LblAdAdresLinia1" runat="server" /><br />
			                <ea:DataLabel ID="LblAdAdresLinia2" runat="server" />
		                </p>
                        </ea:Section>
                    </td>
                </tr>
            </tbody>
        </table>
	<p>
		Stosownie do przepisów ustawy o rachunkowości z dnia 29 września 1994 r. (Dz. U. z 2021 r. poz. 217 ze zm.) uprzejmie prosimy o potwierdzenie w terminie 30 dni zgodności sald rozliczeń
		figurujących w naszych księgach rachunkowych na dzień:&nbsp;<ea:DataLabel ID="DataLabel8" runat="server" DataMember="Data" />.<br />
		W przypadku niezgodności salda prosimy o przesłanie specyfikacji transakcji składających się na różnice.
	</p>
	<ea:DataRepeater ID="DataRepeater1" runat="server" Width="100%" WithSections="false">
		<p>
			<ea:Grid ID="Grid1" runat="server" DataMember="Pozycje" CellBorder="None" RowTypeName="Soneta.Kasa.PotwierdzenieSaldaPozycja,Soneta.Kasa">
				<Columns>
					<ea:GridColumn Width="25" DataMember="NumerDokumentu" Caption="Dokument" runat="server"/>
					<ea:GridColumn DataMember="Opis" Caption="Opis" runat="server" />
					<ea:GridColumn Width="12" Align="Center" DataMember="DataDokumentu" Caption="Data" runat="server" />
					<ea:GridColumn Width="12" Align="Center" DataMember="TerminZaplaty" Caption="Termin" runat="server" />
					<ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Format="{0:n}" runat="server" />
					<ea:GridColumn Width="12" Align="Right" DataMember="Należność" Caption="Należności" HideZero="True" Format="{0:n}" runat="server"/>
					<ea:GridColumn Width="12" Align="Right" DataMember="Zobowiązanie" Caption="Zobowiązania" HideZero="True" Format="{0:n}" runat="server" />
				</Columns>
			</ea:Grid>
            <div>
			    <table id="Table1" cellspacing="0" width="100%">
				    <tr>
					    <td align="right" width="50%">
						    Konto: <ea:DataLabel ID="Datalabel18" runat="server" DataMember="Konto" />
					    </td>
					    <td align="right" width="15%">
						    Waluta: <ea:DataLabel ID="DataLabel16" runat="server" DataMember="Symbol"/>
					    </td>
					    <td align="right">
						    <ea:Grid ID="Grid5" runat="server" DataMember="Podsumowanie" ShowHeader="None" WithSections="false">
							    <Columns>
								    <ea:GridColumn DataMember="Opis" />
								    <ea:GridColumn Width="12" runat="server" Align="Right" ID="CmNaleznoscId1" DataMember="Należność" HideZero="True" Format="{0:n}" />
								    <ea:GridColumn Width="12" runat="server" Align="Right" ID="CmZobowiazanieId1" DataMember="Zobowiązanie" HideZero="True" Format="{0:n}" />
							    </Columns>
						    </ea:Grid>
					    </td>
				    </tr>
			    </table>
            </div>
		</p>
	</ea:DataRepeater>
	<p>
		<ea:DataLabel ID="DataLabel7" runat="server" DataMember="Opis" Bold="False" />
	</p>
	<p>
		<ea:Section runat="server" ID="SectionPrzypomnienieId">
			Przypominamy o uregulowaniu naszych należności.
		</ea:Section>
	    <p>
        </p>
        <p>
            <cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" 
                TheEnd="False">
                <Subtitles>
                    <cc1:FooterSubtitle runat="server" SubtitleType="Operator" Width="50" />
                    <cc1:FooterSubtitle runat="server" Caption="Data i podpis" Width="50" />
                </Subtitles>
            </cc1:ReportFooter>
        </p>
	    <p>
        </p>
	    <p>
        </p>
	</p>

	</ea:DataRepeater>

	<ea:DataRepeater runat="server" Id="BlockB" WithSections="false">
    
		<ea:PageBreak ID="PageBreak1" runat="server" ResetPageCounter="true" />

	<cc1:ReportHeader ID="Reportheader2" Title="Potwierdzenie salda|</strong>Numer: <strong>{0}|</strong>Na dzień: <strong>{1}|ODCINEK B" runat="server" DataMember1="Data" DataMember0="Numer"  />
	<p>
		<em>Nadawca:</em><br />
		<ea:DataLabel ID="Lbl2Podmiot" runat="server" /><br />
		<ea:DataLabel ID="Lbl2AdresLinia1" runat="server" /><br />
		<ea:DataLabel ID="Lbl2AdresLinia2" runat="server" />
	</p>
	<p>
		<em>Odbiorca:</em><br/>
		<ea:DataLabel ID="IdNazwaWlasna2" runat="server" />
	</p>
	<p>
		Potwierdzam zgodność niżej wyszczególnionych sald na dzień&nbsp;<ea:DataLabel ID="Datalabel15" runat="server" DataMember="Data"/>.<br />
		Saldo zgodne / saldo niezgodne z powodu:<br />
		................................................................................................................................................................<br />
		................................................................................................................................................................
	</p>
	<ea:DataRepeater ID="DataRepeater2" runat="server" Width="100%" WithSections="false">
		<p>
			<ea:Grid ID="Grid3" runat="server" DataMember="Pozycje" CellBorder="None" RowTypeName="Soneta.Kasa.PotwierdzenieSaldaPozycja,Soneta.Kasa">
				<Columns>
					<ea:GridColumn Width="25" DataMember="NumerDokumentu" Caption="Dokument" runat="server"/>
					<ea:GridColumn DataMember="Opis" Caption="Opis" runat="server"/> 
					<ea:GridColumn Width="12" Align="Center" DataMember="DataDokumentu" Caption="Data" runat="server"/>
					<ea:GridColumn Width="12" Align="Center" DataMember="TerminZaplaty" Caption="Termin" runat="server"/>
					<ea:GridColumn Width="12" Align="Right" DataMember="Kwota" Format="{0:n}" runat="server"/>
					<ea:GridColumn Width="12" Align="Right" DataMember="Zobowiązanie" Caption="Należności" HideZero="True" Format="{0:n}" runat="server"/>
					<ea:GridColumn Width="12" Align="Right" DataMember="Należność" Caption="Zobowiązania" HideZero="True" Format="{0:n}" runat="server"/>
				</Columns>
			</ea:Grid>
            <div>
                <table id="Table2" cellspacing="0" width="100%">
                    <tr>
                        <td align="right" width="50%">Konto:
                            <ea:DataLabel ID="Datalabel19" runat="server" DataMember="Konto" />
                        </td>
                        <td align="right" width="15%">Waluta:
                            <ea:DataLabel ID="DataLabel17" runat="server" DataMember="Symbol" />
                        </td>
                        <td align="right">
                            <ea:Grid ID="Grid2" runat="server" DataMember="Podsumowanie" ShowHeader="None" WithSections="false">
                                <Columns>
                                    <ea:GridColumn DataMember="Opis" />
                                    <ea:GridColumn Width="12" Align="Right" runat="server" DataMember="Zobowiązanie" ID="CmNaleznoscId2" HideZero="True" Format="{0:n}" />
                                    <ea:GridColumn Width="12" Align="Right" runat="server" DataMember="Należność" ID="CmZobowiazanieId2" HideZero="True" Format="{0:n}" />
                                </Columns>
                            </ea:Grid>
                        </td>
                    </tr>
                </table>
            </div>
		</p>
	</ea:DataRepeater>
	<p>
		<cc1:ReportFooter ID="Reportfooter2" runat="server" TheEnd="False" Height="105px">
			<Subtitles>
				<cc1:FooterSubtitle runat="server" SubtitleType="Operator" Width="50"/>
				<cc1:FooterSubtitle runat="server" Caption="Data i podpis" Width="50"/>
			</Subtitles>
		</cc1:ReportFooter>
	</p>
	</ea:DataRepeater>

	</form>
</body>
</html>
